## Desde php
    $method = __METHOD__; // en un metodo, function dentro de clase
    $function = __FUNCTION__; // en un function
    $sqlComment = __FILE__ . ":" . __LINE__; // a medio archivo
    global $gStrIt;
    $sql = "SELECT /*$method*/ * FROM empresa WHERE empresa_id = {$gStrIt($empresa_id)}";

## Toda tabla debe 

### Tener los campos de control de datos
    alta_db datetime default CURRENT_TIMESTAMP not null,
    alta_por varchar(16) default 'sistema' not null,
    ultimo_cambio datetime default CURRENT_TIMESTAMP not null,
    ultimo_cambio_por varchar(16) default 'sistema' not null,

### Ejemplo
    CREATE TABLE tipo_color (
        tipo_color_id int unsigned NOT NULL AUTO_INCREMENT PRIMARY KEY,
        -- tipo_color_id  VARCHAR(32) NOT NULL PRIMARY KEY, -- cuando pueda ser distribuido
        tipo_color VARCHAR(191) NOT NULL COMMENT 'Nombre o label del record',
        UNIQUE KEY tipo_unico(tipo_color),
        orden smallint unsigned default '1000' not null comment 'Hacer el ORDER BY orden, tipo_color',
        alta_db datetime default CURRENT_TIMESTAMP not null,
        alta_por varchar(16) default 'sistema' not null,
        ultimo_cambio datetime default CURRENT_TIMESTAMP not null,
        ultimo_cambio_por varchar(16) default 'sistema' not null
    ) COMMENT 'Para clasificar los colores 1 color 1 tipo_color';
    -- defaults
    INSERT INTO tipo_color(tipo_color, orden, alta_por) VALUES
        ('LISO', 1, 'rony'),
        ('COMPUESTO', 2, 'rony'),
        ('RARO', 3, 'rony');


## Ejemplo virtual column para app_
    SELECT c.color_id, c.color, c.activo,
        (
            SELECT SUM(pb.existencia_rollos)
            FROM producto_bodega pb
            WHERE pb.color_id = c.color_id
        ) as virtual_column_existencia_rollos
    FROM color c
    ORDER BY c.orden, c.color;

# JSON FIELDS


## JSON COLUMNS
### Default
    json_object JSON NOT NULL DEFAULT (JSON_OBJECT()) COMMENT ' default needs mysql version >=  8.0.13',
    o
    json_array JSON NOT NULL DEFAULT (JSON_ARRAY()) COMMENT ' default needs mysql version >=  8.0.13',
    * tip update nulls then alter, if needed

### Index (Single level, json_object, {})
    ALTER TABLE book ADD COLUMN title VARCHAR(191) GENERATED ALWAYS AS (properties ->> "$.title");
    CREATE INDEX book_title_idx ON book (title);
    or
    CREATE TALBE jsonIndexed (
        content JSON NOT NULL DEFAULT (JSON_OBJECT()),
        INDEX json_indexing_content_num_idx ((JSON_VALUE(content, '$.num' RETURNING SIGNED))),
        INDEX json_indexing_content_str_idx ((JSON_VALUE(content, '$.str' RETURNING VARCHAR(200)))),
    );


### Where (Single level, json_object, {})
    SELECT isbn FROM book WHERE properties ->> "$.title" = 'High-Performance Java Persistence';

### Update a key (Single level, json_object, {})
    UPDATE book SET 
        properties = JSON_SET( properties, '$.title', 'High-Performance Java Persistence, 2nd edition' )
    WHERE isbn = '978-9730228236'

### JSON ARRAY, [], TABLE JOIN EXAMPLE
        SELECT /*ejemplo*/ 
          nb.nota_bodega_id,  a.top_ord, b.bodega, nb.entrada_salida, nb.numero, nb.tipo, 
          ob.clave as destino, nb.ayudantes,
          ay.ayudante_id, a.display, ay.es_encargado,  obay.clave as puede_ayudar_en, 
          oba.activo as 'ayudante_activo_destino',
          a.alta_db, a.alta_por
        FROM nota_bodega nb
            JOIN bodega b on nb.bodega_id = b.bodega_id
            JOIN origen_bodega ob on nb.origen_id = ob.origen_bodega_id
              JOIN JSON_TABLE(
                nb.ayudantes_json, '$[*]'  COLUMNS(
                    top_ord FOR ORDINALITY,
                    ayudante_id VARCHAR(32) PATH '$.id',
                    fue_error CHAR(2) PATH '$.fue_error',
                    alta_db DATETIME PATH '$.alta_db',
                    alta_por VARCHAR(32) PATH '$.alta_por',
                    display VARCHAR(191) PATH '$.display'
                    )
            ) as a ON a.fue_error = 'No'
            JOIN ayudantes ay ON ay.ayudante_id = a.ayudante_id
            LEFT OUTER JOIN origen_bodega_ayudantes oba ON
                oba.ayudante_id = ay.ayudante_id AND
                ob.origen_bodega_id = oba.origen_bodega_id
            LEFT OUTER JOIN origen_bodega obay ON oba.origen_bodega_id = obay.origen_bodega_id
        WHERE nb.tipo <> 'Cancelacion' AND nb.destino_fuerza_ok = 'No'
        AND (oba.origen_bodega_id IS NULL OR a.ayudante_id = '484d7ee23af386f611ed1fe0112d5cb0');



